﻿#!/usr/bin/python
# -*- coding: utf-8 -*-
#
""" ** get-rss_batebu-dump.py **

PARAMETERS: username OutputDir pageMAX
"""
# THIS CODE IS DEVELOPED BASED ON Hatena Bookmark Dump Tool(hatebu-dump)
# OF Mr. Satoshi Fukutomi ( http://blog.fuktommy.com/1246924516 ).

# Copyright (c) 2014 TAKAGI-1 (TAKAGI Hitoshi, http://takagi1.net/).
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHORS AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.

"""This script refered id:ymotongpoo's WSSE client.
http://d.hatena.ne.jp/ymotongpoo/20081201/1228115936
http://code.google.com/p/0x7d8/source/browse/trunk/ymotongpoo/APIs/WSSE.py

The WSSE client released under Apache License 2.0.
http://www.apache.org/licenses/LICENSE-2.0
"""
#
# Copyright (c) 2009 Satoshi Fukutomi <info@fuktommy.com>.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHORS AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# $Id$
#
import base64
import optparse
import os.path
import socket
import sys
import threading
import time
import urllib
from datetime import datetime
from getpass import getpass
from random import random
from sha import sha

__author__ = 'Fuktommy'
__version__ = '$Revision$'

VERSION = __version__[11:-1].strip()


class WsseHeader:
    """WSSE authorized HTTP Request Header.

    This class refered id:ymotongpoo's WSSE client.
    """

    def __init__(self, userid, password):
        self.userid = userid
        self.password = password

    def create_header_token(self):
        nonce = sha(str(time.time() + random())).digest()
        nonce64 = base64.encodestring(nonce).strip()

        created = datetime.utcnow().isoformat() + 'Z'

        passdigest = sha(nonce + created + self.password).digest()
        pass64 = base64.encodestring(passdigest).strip()

        wsse = ('UsernameToken Username="%(u)s", PasswordDigest="%(p)s",'
                + ' Nonce="%(n)s", Created="%(c)s"')
        value = {'u': self.userid, 'p': pass64, 'n': nonce64, 'c': created}

        return wsse % value

    def get_request_header(self):
        return [('X-WSSE', self.create_header_token()),
                ('Authorization', 'WSSE profile="UsernameToken"')]


def get_request_header(username, password):
    ret = WsseHeader(username, password).get_request_header()
    ret.append(('User-Agent', 'Hatebu-Dump/' + VERSION))
    return ret


def is_unauthorized(err):
    return (isinstance(err.args, tuple)
        and (len(err.args) >= 3)
        and (err.args[2] == 'Unauthorized'))


def main():
    if len(sys.argv) != 4:
        sys.exit('PARAMETERS: username OutputDir pageMAX')
    username = sys.argv[1]
    OutputDir = sys.argv[2]
    imax = int(sys.argv[3])

    password = getpass('Password:')

    for i in range(imax):
    
        print "============================================"
	print u"Now getting: %d th xml file of bookmarks." % (i)
	print "============================================"

#        url = 'http://b.hatena.ne.jp/' + username + '/rss?of=' + str(i*20)
        url = 'http://b.hatena.ne.jp/' + username + '/bookmark.rss?page=' + str(i+1) # 2018/12/31

        agent = urllib.URLopener()
        socket.setdefaulttimeout(900)

        buf = None
        while True:
            try:
                agent.addheaders = get_request_header(username, password)
                print agent.addheaders
                con = agent.open(url)
                print con.info()
                buf = con.read()
                break
            except Exception, err:
                print err
                if is_unauthorized(err):
                    break
                time.sleep(60)

        if buf:
            file(OutputDir + '/' + str(i) + '.xml', 'wb').write(buf)

        time.sleep(30)

if __name__ == '__main__':
    main()